export interface ServerToClientEvents {
  "dashboard-update": (data: {
    type: "sales" | "expense" | "inventory"
    data: any
    timestamp: string
  }) => void
  notification: (data: {
    type: "success" | "error" | "info"
    title: string
    message: string
    timestamp: string
  }) => void
  "user-activity": (data: {
    userId: string
    action: string
    timestamp: string
  }) => void
}

export interface ClientToServerEvents {
  "join-room": (room: string) => void
  "leave-room": (room: string) => void
  ping: () => void
}

export interface InterServerEvents {
  ping: () => void
}

export interface SocketData {
  userId: string
  email: string
  role: string
}
