// Utility functions for business calculations

export function calculateSalesTotals(salesData: {
  cashInShop: number
  cashDelivery: number
  cashWolt: number
  cashBolt: number
  cashPyszne: number
  cashUberEats: number
  cashGlovo: number
  cardInShop: number
  cardDelivery: number
  cardWolt: number
  cardBolt: number
  cardPyszne: number
  cardUberEats: number
  cardGlovo: number
}) {
  const totalCash =
    salesData.cashInShop +
    salesData.cashDelivery +
    salesData.cashWolt +
    salesData.cashBolt +
    salesData.cashPyszne +
    salesData.cashUberEats +
    salesData.cashGlovo

  const totalCard =
    salesData.cardInShop +
    salesData.cardDelivery +
    salesData.cardWolt +
    salesData.cardBolt +
    salesData.cardPyszne +
    salesData.cardUberEats +
    salesData.cardGlovo

  const totalSales = totalCash + totalCard

  return { totalCash, totalCard, totalSales }
}

export function calculateSalaryTotals(salaryData: {
  hourlyRate?: number
  totalHours?: number
  received?: number
}) {
  const totalSalary = (salaryData.hourlyRate || 0) * (salaryData.totalHours || 0)
  const payable = totalSalary - (salaryData.received || 0)

  return { totalSalary, payable }
}

export function calculateTaxTotals(taxData: {
  netto?: number
  vat?: number
}) {
  const brutto = (taxData.netto || 0) + (taxData.vat || 0)
  return { brutto }
}

export function formatCurrency(amount: number): string {
  return new Intl.NumberFormat("pl-PL", {
    style: "currency",
    currency: "PLN",
  }).format(amount)
}

export function formatDate(date: Date): string {
  return new Intl.DateTimeFormat("pl-PL").format(date)
}
