import type { ObjectId } from "mongodb"

export interface User {
  _id?: ObjectId
  name: string
  email: string
  phone: string
  password: string
  role: "admin" | "manager" | "owner"
  branchIds?: ObjectId[]
  createdAt: Date
  updatedAt: Date
  isActive: boolean
}

export interface CreateUserInput {
  name: string
  email: string
  phone: string
  password: string
  role: "admin" | "manager" | "owner"
  branchIds?: string[]
}

export interface UpdateUserInput {
  name?: string
  email?: string
  phone?: string
  password?: string
  branchIds?: string[]
  isActive?: boolean
}
