import type { ObjectId } from "mongodb"

export interface Sales {
  _id?: ObjectId
  date: Date
  branchId: ObjectId

  // Cash transactions
  cashInShop: number
  cashDelivery: number
  cashWolt: number
  cashBolt: number
  cashPyszne: number
  cashUberEats: number
  cashGlovo: number

  // Card transactions
  cardInShop: number
  cardDelivery: number
  cardWolt: number
  cardBolt: number
  cardPyszne: number
  cardUberEats: number
  cardGlovo: number

  // Totals
  totalCash: number
  totalCard: number
  totalSales: number

  notes?: string
  createdBy: ObjectId
  createdAt: Date
  updatedAt: Date
}

export interface CreateSalesInput {
  date: string
  branchId: string
  cashInShop: number
  cashDelivery: number
  cashWolt: number
  cashBolt: number
  cashPyszne: number
  cashUberEats: number
  cashGlovo: number
  cardInShop: number
  cardDelivery: number
  cardWolt: number
  cardBolt: number
  cardPyszne: number
  cardUberEats: number
  cardGlovo: number
  notes?: string
}
