import type { ObjectId } from "mongodb"

export type InventoryType = "daily-consumption" | "stock-level"

export interface Inventory {
  _id?: ObjectId
  date: Date
  branchId: ObjectId
  type: InventoryType

  // Food items
  kurczak: number
  wolowina: number
  kraftowe: number
  majonez: number
  ketchup: number
  smabal: number
  yogurt: number
  pita20cm: number
  pita30cm: number
  gas: number

  notes?: string
  createdBy: ObjectId
  createdAt: Date
  updatedAt: Date
}

export interface CreateInventoryInput {
  date: string
  branchId: string
  type: InventoryType
  kurczak: number
  wolowina: number
  kraftowe: number
  majonez: number
  ketchup: number
  smabal: number
  yogurt: number
  pita20cm: number
  pita30cm: number
  gas: number
  notes?: string
}
