import type { ObjectId } from "mongodb"

export type ExpenseCategory =
  | "cost-of-sales"
  | "utilities"
  | "office-expenses"
  | "delivery-cost"
  | "managing-expenses"
  | "shop-rent"
  | "salaries"
  | "fooding-expense"
  | "home-expenses"
  | "salaries-calculations"
  | "repair-maintenance"
  | "bank-charges"
  | "others"
  | "personal-withdraw"

export interface Expense {
  _id?: ObjectId
  date: Date
  branchId: ObjectId
  category: ExpenseCategory
  subcategory?: string

  // Basic expense fields
  amount: number
  description: string
  paymentMethod: "cash" | "card" | "bank-transfer"

  // Salary calculation fields (for salary categories)
  employeeId?: ObjectId
  hourlyRate?: number
  totalHours?: number
  totalSalary?: number
  received?: number
  payable?: number

  // Tax fields
  netto?: number
  vat?: number
  brutto?: number

  // Additional fields
  fakturaNo?: string
  notes?: string
  attachments?: string[]
  paymentDate?: Date

  createdBy: ObjectId
  createdAt: Date
  updatedAt: Date
}

export interface CreateExpenseInput {
  date: string
  branchId: string
  category: ExpenseCategory
  subcategory?: string
  amount: number
  description: string
  paymentMethod: "cash" | "card" | "bank-transfer"
  employeeId?: string
  hourlyRate?: number
  totalHours?: number
  totalSalary?: number
  received?: number
  payable?: number
  netto?: number
  vat?: number
  brutto?: number
  fakturaNo?: string
  notes?: string
  paymentDate?: string
}
