import type { ObjectId } from "mongodb"

export interface Branch {
  _id?: ObjectId
  name: string
  address: string
  country?: string
  location?: string
  ownerId?: ObjectId
  managerId?: ObjectId
  isActive: boolean
  createdAt: Date
  updatedAt: Date
}

export interface CreateBranchInput {
  name: string
  address: string
  country?: string
  location?: string
  ownerId?: string
  managerId?: string
}

export interface UpdateBranchInput {
  name?: string
  address?: string
  country?: string
  location?: string
  ownerId?: string
  managerId?: string
  isActive?: boolean
}
