import { getDatabase } from "../mongodb"
import type { User } from "../models/User"
import type { Branch } from "../models/Branch"
import type { Sales } from "../models/Sales"
import type { Expense } from "../models/Expense"
import type { Inventory } from "../models/Inventory"
import type { Employee } from "../models/Employee"

async function handleDatabaseOperation<T>(operation: () => Promise<T>): Promise<T> {
  try {
    return await operation()
  } catch (error) {
    if (error instanceof Error && error.message.includes("MongoDB connection not initialized")) {
      throw new Error("Database is not available. Please configure MONGODB_URI environment variable.")
    }
    throw error
  }
}

export async function getUsersCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<User>("users")
  })
}

export async function getBranchesCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<Branch>("branches")
  })
}

export async function getSalesCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<Sales>("sales")
  })
}

export async function getExpensesCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<Expense>("expenses")
  })
}

export async function getInventoryCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<Inventory>("inventory")
  })
}

export async function getEmployeesCollection() {
  return handleDatabaseOperation(async () => {
    const db = await getDatabase()
    return db.collection<Employee>("employees")
  })
}
