import { type NextRequest, NextResponse } from "next/server"
import { getSessionFromRequest } from "./session-simple"

export async function authMiddleware(request: NextRequest) {
  const session = await getSessionFromRequest(request)

  if (!session) {
    return NextResponse.redirect(new URL("/login", request.url))
  }

  // Add user info to headers for use in components
  const response = NextResponse.next()
  response.headers.set("x-user-id", session.userId)
  response.headers.set("x-user-email", session.email)
  response.headers.set("x-user-role", session.role)

  return response
}

export function requireRole(allowedRoles: string[]) {
  return async (request: NextRequest) => {
    const session = await getSessionFromRequest(request)

    if (!session) {
      return NextResponse.redirect(new URL("/login", request.url))
    }

    if (!allowedRoles.includes(session.role)) {
      return NextResponse.json({ error: "Insufficient permissions" }, { status: 403 })
    }

    return NextResponse.next()
  }
}
