"use client"

import { useState, useEffect } from "react"
import { useRouter } from "next/navigation"
import type { User } from "@/lib/models/User"

interface AuthUser extends Omit<User, "password"> {}

export function useAuth() {
  const [user, setUser] = useState<AuthUser | null>(null)
  const [isLoading, setIsLoading] = useState(true)
  const router = useRouter()

  useEffect(() => {
    checkAuth()
  }, [])

  const checkAuth = async () => {
    try {
      console.log("[v0] Checking auth - using mock data")

      // Simulate API delay
      await new Promise((resolve) => setTimeout(resolve, 500))

      // Mock user data
      const mockUser = {
        _id: "mock-user-id",
        name: "John Doe",
        email: "john@example.com",
        role: "admin" as const,
        phone: "+1234567890",
        createdAt: new Date(),
        updatedAt: new Date(),
      }

      setUser(mockUser)
    } catch (error) {
      console.error("Auth check failed:", error)
      setUser(null)
    } finally {
      setIsLoading(false)
    }
  }

  const login = async (email: string, password: string) => {
    console.log("[v0] Mock login for:", email)

    const mockUser = {
      _id: "mock-user-id",
      name: "John Doe",
      email: email,
      role: "admin" as const,
      phone: "+1234567890",
      createdAt: new Date(),
      updatedAt: new Date(),
    }

    setUser(mockUser)
    router.push("/")
    router.refresh()

    return { success: true, data: mockUser }
  }

  const logout = async () => {
    try {
      console.log("[v0] Logout clicked")
      setUser(null)
      router.push("/login")
      router.refresh()
    } catch (error) {
      console.error("Logout failed:", error)
    }
  }

  const register = async (userData: {
    name: string
    email: string
    phone?: string
    password: string
    role?: "admin" | "manager" | "owner"
  }) => {
    console.log("[v0] Mock register for:", userData.email)

    const mockUser = {
      _id: "mock-user-id",
      name: userData.name,
      email: userData.email,
      role: userData.role || ("admin" as const),
      phone: userData.phone || "",
      createdAt: new Date(),
      updatedAt: new Date(),
    }

    setUser(mockUser)
    router.push("/")
    router.refresh()

    return { success: true, data: mockUser }
  }

  return {
    user,
    isLoading,
    login,
    logout,
    register,
    checkAuth,
  }
}
