import { NextResponse } from "next/server"
import { deleteSession } from "@/lib/auth/session-simple"

export async function POST() {
  try {
    await deleteSession()

    return NextResponse.json({
      success: true,
      message: "Logged out successfully",
    })
  } catch (error) {
    console.error("Logout error:", error)
    return NextResponse.json({ success: false, error: "Internal server error" }, { status: 500 })
  }
}
